/*---------------------------------------------------
   չOWRAMO_ॿ`s
	 }:0000 ~ 7FFF
   CӦ}sJ0x55AŪXAgJ0xAAAŪXA
   ݬO_TAY~hAܸӦ}C
  
-----------------------------------------------------*/
#include "reg52.h"
#include <stdio.h>
#include <stdlib.h>
#include <String.h>
#include <absacc.h>

#define RAM_START 0x0000
#define RAM_END   0x7FFF

//-------- LCD禡 ----------------------------------
sbit sda = P1^0;
sbit scl = P1^1;
#define SLAVE 0x4E   //LCM1602}wq

//-------------------------------------------------------
void delay(unsigned int dl){
  while (dl>0)
  dl--;
}
//-------------------------------------------------------
void start(){
  scl = 1;
  delay(5);
  sda = 1;
  delay(5);
  sda = 0;
  delay(4);
}
//-------------------------------------------------------
void send_8bits(unsigned char strg){
  unsigned char sf;
  for (sf=0; sf<8; sf++)
  {
    scl = 0;
    sda =(bit)(strg & (0x80>>sf));
    delay(5);
    scl = 1;
    delay(4);
  }
  scl = 0;
  delay(5);
}
//-------------------------------------------------------
void ack(void){
  sda = 1; 
  if(sda == 0)
  {  
    scl = 1;
    delay(4);
    scl = 0;
    delay(5);
  }
}
//-------------------------------------------------------
/*
void stop(void){
  sda = 0;
  scl = 1;
  delay(5);
  sda = 1;
}
*/
//-------------------------------------------------------
void WriteInst4bits(unsigned char inst_4b){
  send_8bits(0x08);         //RS=0, RW=0
  ack();
  send_8bits(0x0C);         //EN=1
  ack();
  send_8bits((inst_4b&0xF0)+0x0C); //eXD7-D4
  ack();
  send_8bits((inst_4b&0xF0)+0x08); //EN=0 Ū|줸
  ack();
}
//-------------------------------------------------------
void WriteInst(unsigned char inst){ 
  send_8bits(0x08);         //RS=0, RW=0
  ack();
  send_8bits(0x0C);         //EN=1
  ack();
  send_8bits((inst&0xF0)+0x0C);   //|
  ack();
  send_8bits((inst&0xF0)+0x08);   //EN=0 Ū|
  ack();
 
  send_8bits(0x0C);         //EN=1
  ack();
  send_8bits((inst<<4)+0x0C);    //C|
  ack();
  send_8bits((inst<<4)+0x08);    //EN=0 ŪC|
  ack();
} 
//-------------------------------------------------------
void WriteData(unsigned char data_){
  send_8bits(0x09);         //RS=1, RW=0
  ack();
  send_8bits(0x0D);         //EN=1
  ack();
  send_8bits((data_&0xF0)+0x0D);  //|
  ack();
  send_8bits((data_&0xF0)+0x09);  //EN=0 Ū|
  ack();
 
  send_8bits(0x0D);         //EN=1
  ack();
  send_8bits((data_<<4)+0x0D);   //C|
  ack();
  send_8bits((data_<<4)+0x09);   //EN=0 ŪC|
  ack();
} 
//------------------------------------------------------- 
void WriteString(unsigned char count, unsigned char MSG[]){
  unsigned char sf;
  unsigned char move = 0;
  for (sf=0; sf<count; sf++)
    WriteData(MSG[sf]);
}
//-------------------------------------------------------
void ClearLCD(void){
  WriteInst(0x80);  //]wDDRAM}ܦm(Ĥ@1)
	WriteString(sizeof("                ")-1, "                ");
	WriteInst(0xC0);  //]wDDRAM}ܦm(ĤG3)
	WriteString(sizeof("                ")-1,"                ");
}
//-------------------------------------------------------
void LCDinitial(void){
  delay(15000);
 
  start();
  send_8bits(SLAVE);  //ǰeLCM1602}
  ack();
 
  WriteInst4bits(0x30); //gJ0011DB7-4
 
  delay(4100);
 
  WriteInst4bits(0x30); //gJ0011DB7-4
 
  delay(100);

  WriteInst4bits(0x30); //gJ0011DB7-4
  WriteInst4bits(0x20); //gJ0010DB7-4
  
  WriteInst(0x28); //\]w function set, DL(DB4)=0(4줸ǿ), N(DB3)=1(2C), F(DB2)=0(5*7ѪR)
  WriteInst(0x08); //ù display off
  WriteInst(0x01); //Mù clear display
  WriteInst(0x06); //ʼҦ entry mode
  WriteInst(0x0E); //}ҿù display ON, D(DB2)=1(}), C(DB1)=1(ж}), B(DB0)=0({{)
}

//======== Main ============================================
void main()
{ 
  unsigned char MSG_Err[5];
  int flag = 1;
  unsigned char testVal = 0x55; // խ
  unsigned int addr;   

  LCDinitial();
  ClearLCD();

  for(addr = RAM_START; addr <= RAM_END; addr++) {
    XBYTE[addr] = testVal;      // gJխ
      if(XBYTE[addr] != testVal)  // Ūˬd
		    flag = 0;			
		XBYTE[addr] = ~testVal;      // gJխ
      if(XBYTE[addr] != ~testVal)  // Ūˬd
		    flag = 0;
        
    if(!flag)
      break;  
  }
		
  if(flag){    //all pass		 
    WriteInst(0x80);  //]wDDRAM}ܦm(Ĥ@1)
    WriteString(sizeof("All addr pass")-1, "All addr pass");
  }
  else{
    WriteInst(0x80);  //]wDDRAM}ܦm(Ĥ@1)
    WriteString(sizeof("Error at:")-1, "Error at:");
    sprintf(MSG_Err, "%04X\n", addr);
    WriteInst(0xC0);
    WriteString(sizeof(MSG_Err)-1, MSG_Err);   
  }      
  while(1);		 
}